#
# IMPORT THE OR-TOOLS CONSTRAINT SOLVER
#
from ortools.constraint_solver import pywrapcp
import sys
import json

#
# A FUNCTION TO BUILD AND SOLVE A MODEL
# time_limit: if None, not time limit is employed. If integer, a time limit is
#             enforced, but optimality is no longer guaranteed!
def solve_problem(data, time_limit = None):
    # Cache some useful data
    setups = data['setups']
    order_list = data['order_list']
    unit_list = data['unit_list']
    order_table = data['order_table']
    no = len(order_list)
    nu = len(unit_list)

    # Build solver instance
    slv = pywrapcp.Solver('production-scheduling')

    #
    # CREATE VARIABLES
    #

    #### YOUR STUFF HERE ####

    # Objective variable
    z = #### YOUR STUFF HERE ####

    #
    # BUILD CONSTRAINTS AND ADD THEM TO THE MODEL
    #

    #### YOUR STUFF HERE ####

    # z definition constraints
    slv.Add(z == #### YOUR STUFF HERE ####)

    #
    # THOSE ARE THE VARIABLES THAT WE WANT TO USE FOR BRANCHING
    #
    all_vars = #### YOUR STUFF HERE ####

    # DEFINE THE SEARCH STRATEGY
    decision_builder = slv.Phase(all_vars,
                                 slv.INT_VAR_DEFAULT,
                                 slv.INT_VALUE_DEFAULT)

    # INIT THE SEARCH PROCESS

    # log monitor (just to have some feedback)
    # search_monitors = [slv.SearchLog(500000)]
    search_monitors = []
    # enforce a time limit (if requested)
    if time_limit:
       search_monitors.append(slv.TimeLimit(time_limit))
    # enable branch and bound
    search_monitors.append(slv.Minimize(z, 1))

    # init search
    slv.NewSearch(decision_builder, search_monitors)

    # SEARCH FOR A FEASIBLE SOLUTION
    zbest = None
    while slv.NextSolution():
        #
        # PRINT SOLUTION
        #

        #### YOUR STUFF HERE ####

        #
        # STORE SOLUTION VALUE
        #
        zbest = z.Value()

    # print something if no solution was found
    if zbest == None:
        print '*** No solution found'

    # print stats
    branches, time = slv.Branches(), slv.WallTime()
    print '*** Number of branches: %d' % branches
    print '*** Computation time: %f (ms)' % time
    if time_limit != None and slv.WallTime() > time_limit:
        print '*** Time limit exceeded'

    # END THE SEARCH PROCESS
    slv.EndSearch()

    # Return the solution value
    return zbest, branches, time


#
# LOAD PROBLEM DATA
#
if len(sys.argv) != 2:
    print 'Usage: python %s <data file>' % sys.argv[0]
    sys.exit()
else:
    fname = sys.argv[1]

with open(fname) as fin:
    data = json.load(fin)

#
# CALL THE SOLUTION APPROACH
#
solve_problem(data, time_limit=30000)
