function labt()
	% Dimensioni della stanza
	l1 = 9; % profondita'
	l2 = 5; % larghezza
	l3 = 3.5; % altezza
	lg = 2.5; % larghezza della porta finestra
	lw = 0.25; % spessore dei mattoni nelle pareti
	% Grandezze derivate
	Va = l1 * l2 * l3; % volume dell'aria all'interno
	Sg = lg * l3; % superficie della porta finestra
	Sw = 2*l1*l2 + 2*l2*l3 + 2*l1*l3 - Sg; % superficie delle pareti

	% Resistenza dell'aria sulla porta finestra
	R1 = 1 / (0.024 * 1e3 * Sg * 2e2);
	% Resistenza tra l'aria nella stanza e le pareti
	R2 = 1 / (0.7 * 1e3 * Sw * 1.5);
	% Capacita' termica dell'aria nella stanza
	Ca = 1.005 * 1e3 * Va * 1.1839;
	% Capacita' termica delle pareti
	Cw = 0.9 * 1e3 * Sw * lw * 1.6e3;

	% Carico i dati sulla temperatura (in gradi Kelvin)
	data = csvread('temperature.csv');
	To_t = data(:, 1)'; % temperatura esterna (valori)
	To_v = data(:, 2)' + 2.5; % temperatura esterna (tempi)

	% ========================================================================
	% Q1: Determinare l'andamento delle temperature
	% ========================================================================

	dX = @(t, X) dstate1(t, X, R1, R2, Ca, Cw, To_t, To_v)';
	tspan = [0, 194];
	X0 = [27, 27];
	[t, X] = ode45(dX, tspan, X0);

	% Estraggo l'andamento delle due temperature (e converto in gradi Celsius)
	Ta = X(:,1);
	Tw = X(:,2);

	% Visualizzo l'andamento delle temperature
	figure()
	plot(t, Ta)
	hold on
	plot(t, Tw)
	legend('Ta', 'Tw')
	hold off
	grid()
	title('Temperatura (finestra sempre aperta)')

	% ========================================================================
	% Q2: Ripetere il Q1, assumendo che la porta-finestra venga aperta da
	%     mezzanotte fino ad un dato orario 
	% ========================================================================

	dX = @(t, X) dstate2(t, X, R1, R2, Ca, Cw, To_t, To_v, 7)';
	[t, X] = ode45(dX, tspan, X0);

	% Estraggo l'andamento delle due temperature (e converto in gradi Celsius)
	Ta = X(:,1);
	Tw = X(:,2);

	% Visualizzo l'andamento delle temperature
	figure()
	plot(t, Ta)
	hold on
	plot(t, Tw)
	legend('Ta', 'Tw')
	hold off
	grid()
	title('Temperatura (finestra chiusa di giorno)')

	% ========================================================================
	% Q3: Determino la temperatura finale delle pareti
	% ========================================================================

	Tw_f6 = get_final_Tw(R1, R2, Ca, Cw, To_t, To_v, 6)
	Tw_f7 = get_final_Tw(R1, R2, Ca, Cw, To_t, To_v, 7)
	Tw_f8 = get_final_Tw(R1, R2, Ca, Cw, To_t, To_v, 8)

	% ========================================================================
	% Q4: Implementare il metodo di Eulero ed utilizzarlo per risolvere
	%     nuovamente il quesito 2
	% ========================================================================

	X = my_euler(dX, t, X0);

	% Estraggo l'andamento delle due temperature (e converto in gradi Celsius)
	Ta = X(:,1);
	Tw = X(:,2);

	% Visualizzo l'andamento delle temperature
	figure()
	plot(t, Ta)
	hold on
	plot(t, Tw)
	legend('Ta', 'Tw')
	hold off
	grid()
	title('Temperatura (metodo di Eulero)')
end

function dX = dstate1(t, X, R1, R2, Ca, Cw, To_t, To_v)
	% Rinomino le due componenti dello stato (per rendere il codice piu'
	% chiaro)
	Ta = X(1);
	Tw = X(2);
	% Calcolo il valore della temperatura esterna
	To = interp1(To_t, To_v, t);
	% Calcolo il valore dei due flussi di calore
	i1 = (1/R1) * (To -Ta);
	i2 = (1/R2) * (Ta - Tw);
	% Calcolo le derivate delle due temperature
	dX(1) = (1/Ca) * (i1 - i2);
	dX(2) = (1/Cw) * i2;
end

function dX = dstate2(t, X, R1, R2, Ca, Cw, To_t, To_v, gclose)
	% Determino l'ora del giorno
	h = mod(t, 24);
	% Determino se la finestra sia aperta o chiusa
	if (h <= gclose)
		Rmod = R1;
	else
		Rmod = R1 * 10;
	end
	% Calcolo le derivate come nel caso precedente, usando la resistenza
	% modificata al posto di R1
	dX = dstate1(t, X, Rmod, R2, Ca, Cw, To_t, To_v);
end

function Tw_f = get_final_Tw(R1, R2, Ca, Cw, To_t, To_v, gclose)
	dX = @(t, X) dstate2(t, X, R1, R2, Ca, Cw, To_t, To_v, gclose)';
	tspan = [0, 194];
	X0 = [27, 27];
	[t, X] = ode45(dX, tspan, X0);
	Tw_f = X(end, 2);
end

function X = my_euler(f, Ti, x0)
    X(:,1) = x0;
    for i = 2 : length(Ti)
        h = Ti(i)-Ti(i-1);
        X(:,i) = X(:,i-1) + h * f(Ti(i-1), X(:,i-1));
    end
    X = X'; % Traspongo il vettore di uscita
end
