function labt()
	% Dimensioni della stanza
	l1 = 9; % profondita'
	l2 = 5; % larghezza
	l3 = 3.5; % altezza
	lg = 2.5; % larghezza della porta finestra
	lw = 0.25; % spessore dei mattoni nelle pareti
	% Grandezze derivate
	Va = l1 * l2 * l3; % volume dell'aria all'interno
	Sg = lg * l3; % superficie della porta finestra
	Sw = 2*l1*l2 + 2*l2*l3 + 2*l1*l3 - Sg; % superficie delle pareti

	% Resistenza dell'aria sulla porta finestra
	R1 = 1 / (0.024 * 1e3 * Sg * 2e2);
	% Resistenza tra l'aria nella stanza e le pareti
	R2 = 1 / (0.7 * 1e3 * Sw * 1.5);
	% Capacita' termica dell'aria nella stanza
	Ca = 1.005 * 1e3 * Va * 1.1839;
	% Capacita' termica delle pareti
	Cw = 0.9 * 1e3 * Sw * lw * 1.6e3;

	% Carico i dati sulla temperatura (in gradi Kelvin)
	data = csvread('temperature.csv');
	To_t = data(:, 1)'; % temperatura esterna (valori)
	To_v = data(:, 2)' + 2.5; % temperatura esterna (tempi)

	% ========================================================================
	% Q1: Determinare l'andamento delle temperature
	% ========================================================================

	% ========================================================================
	% Q2: Ripetere il Q1, assumendo che la porta-finestra venga aperta da
	%     mezzanotte fino ad un dato orario 
	% ========================================================================

	% ========================================================================
	% Q3: Determino la temperatura finale delle pareti
	% ========================================================================

	% ========================================================================
	% Q4: Implementare il metodo di Eulero ed utilizzarlo per risolvere
	%     nuovamente il quesito 2
	% ========================================================================

end

