function turn1()
    % Dati del problema
    r = 10;
    g = 9.81;
    m = 70;
    Cr = 0.09;

    % ======================================================================
    % Q1: Determino l'andamento della posizione e della velocita'
    % ======================================================================

    tspan = [0, 20];
    x0 = [-0.9*r, 0];
    f = @(t, x) dstate(x, g, r, m, Cr)';
    [t, X] = ode45(f, tspan, x0);

    % Estraggo le due componenti dello stato
    x = X(:, 1); % posizione x
    v = X(:, 2); % velocita' tangenziale

    % Disegno l'andamento della velocita' tangenziale
    figure()
    plot(t, v, 'linewidth', 2);
    grid();
    xlabel('Tempo', 'fontsize', 14);
    ylabel('Velocita''', 'fontsize', 14);


    % Disegno l'andamento della posizione
    figure()
    plot(t, x, 'linewidth', 2);
    grid();
    xlabel('Tempo', 'fontsize', 14);
    ylabel('Posizione (x)', 'fontsize', 14);

    % ======================================================================
    % Q2: Determino una serie di valori di interesse
    % ======================================================================

    % Velocita' massima
    vmax = max(v)

    % Velocita' dopo 1 secondo
    v1s = interp1(t, v, 1)

    % Posizione dopo 1 secondo
    x1sec = interp1(t, x, 1);

    % ======================================================================
    % Q3: Determino il coefficiente di rotolamento per perche' la velocita'
    %     massima sia di 10 m/s
    % ======================================================================

    fz = @(Cr) vmax_with_Cr(g, r, m, Cr) - 10;
    [Crsol, fval, flag] = fzero(fz, Cr)

    % ======================================================================
    % Q4: Si risolva il Q3 utilizzando il metodo della bisezione
    % ======================================================================

    [Crsol2, fval2] = my_bisection(fz, 0.5*Cr, Cr)
end

function vmax = vmax_with_Cr(g, r, m, Cr)
    tspan = [0, 20];
    x0 = [-0.9*r, 0];
    f = @(t, x) dstate(x, g, r, m, Cr)';
    [t, X] = ode45(f, tspan, x0);
    x = X(:, 1); % posizione x
    v = X(:, 2); % velocita' tangenziale
    vmax = max(v);
end

function dx = dstate(x, g, r, m, Cr)
    % x(1) = posizione x, x(2) = velocita' tangenziale
    % La derivata della funzione che descrive la curva e':
    dphi = x(1) / sqrt(r.^2 - x(1).^2);
    % La norma del vettore tangente e del suo vettore ortogonale e':
    nT = sqrt(1 + dphi^2);
    % La forza di gravita' (proiettata sulla tangente) è data da:
    Fg = - g .* m .* (dphi ./ nT);
    % La forza normale e' data da:
    Fn = g .* m .* (1 ./ nT);
    % La forza di attrito volvente e' data da:
    Fr = - Cr .* Fn .* tanh(4.*x(2));
    % Calcolo le derivate
    dx(1) = x(2) / nT;
    dx(2) = (Fg + Fr) ./ m;
end

function [x, fval] = my_bisection(f, x0, x1)
    tol = 1e-6;
    while true
        % Calcolo il prossimo valore di x
        x = 0.5 * (x0 + x1);
        fval = f(x);
        % Controllo se non sia il momento di terminare
        if abs(x - x0) <= tol
            break;
        end
        % Rimpiazzo x0 o x1
        if f(x0) * f(x) < 0
            x1 = x;
        else
            x0 = x;
        end
    end
end

