function turn1()
    % Dati del problema
    r = 10;
    g = 9.81;
    m = 70;

    % ======================================================================
    % Q1: Determino l'andamento della posizione e della velocita'
    % ======================================================================

    tspan = [0, 3];
    x0 = [-0.9*r, 0];
    f = @(t, x) dstate(x, g, r, m)';
    [t, X] = ode45(f, tspan, x0);

    % Estraggo le due componenti dello stato
    x = X(:, 1); % posizione x
    v = X(:, 2); % velocita' tangenziale

    % Disegno l'andamento della velocita' tangenziale
    figure()
    plot(t, v, 'linewidth', 2);
    grid();
    xlabel('Tempo', 'fontsize', 14);
    ylabel('Velocita''', 'fontsize', 14);

    % Disegno l'andamento della posizione
    figure()
    plot(t, x, 'linewidth', 2);
    grid();
    xlabel('Tempo', 'fontsize', 14);
    ylabel('Posizione (x)', 'fontsize', 14);

    % ======================================================================
    % Q2: Determino una serie di valori di interesse
    % ======================================================================

    % Velocita' massima
    vmax = max(v)

    % Posizione dopo un secondo
    x1sec = interp1(t, x, 1);

    % Strada percorsa in un secondo
    phi = @(x) -sqrt(r.^2 - x.^2); % funzione che descrive la curva
    dphi = @(x) x ./ sqrt(r.^2 - x.^2); % derivata di phi
    dL = @(x) sqrt(1 + dphi(x).^2); % lunghezza del vettore tangente

    L1sec = integral(dL, -0.9*r, x1sec) % Integrale del vettore tangente

    % ======================================================================
    % Q3: Determino il raggio della rampa perche' la velocita' massima sia
    %     di 8 m/s (versione 1)
    % ======================================================================

    % Versione 1 (niente attrito)
    fz = @(r) vmax_with_r(g, r, m) - 8;
    [rsol, fval, flag] = fzero(fz, r)

    % ======================================================================
    % Q4: Risolvo il Q1, utilizzando il metodo di Eulero
    % ======================================================================

    X2 = my_euler(f, t, x0);
    x2 = X2(:, 1); % estraggo l'andamento della posizione
    v2 = X2(:, 2); % estraggo l'andamento della velocita'

    figure();
    plot(t, v, 'linewidth', 2);
    hold on
    plot(t, v2, 'linewidth', 2);
    hold off
    grid()
    xlabel('Tempo', 'fontsize', 14);
    ylabel('Velocita''', 'fontsize', 14);
end

function vmax = vmax_with_r(g, r, m)
    tspan = [0, 3];
    x0 = [-0.9*r, 0];
    f = @(t, x) dstate(x, g, r, m)';
    [t, X] = ode45(f, tspan, x0);
    x = X(:, 1); % posizione x
    v = X(:, 2); % velocita' tangenziale
    vmax = max(v);
end

function dx = dstate(x, g, r, m)
    % x(1) = posizione x, x(2) = velocita' tangenziale
    % La derivata della funzione che descrive la curva e':
    dphi = x(1) / sqrt(r.^2 - x(1).^2);
    % La norma del vettore tangente e':
    nT = sqrt(1 + dphi^2);
    % La forza di gravita' (proiettata sulla tangente) è data da:
    Fg = - g .* m .* (dphi ./ nT);
    % Calcolo le derivate
    dx(1) = x(2) / nT;
    dx(2) = Fg ./ m;
end

function [X, num_fval] = my_euler(f, Ti, x0)
    X(:,1) = x0;
    for i = 2 : length(Ti)
        h = Ti(i)-Ti(i-1);
        X(:,i) = X(:,i-1) + h * f(Ti(i-1), X(:,i-1));
    end
    num_fval = length(Ti)-1;
    X = X'; % Traspongo il vettore di uscita
end

