function es_roller_coaster()
    g = 9.81;
    a = 20;
    b = 20;
    m = 300;
    vmin = 21;

    % ==========================================================================
    % Q1: disegno la curva e determino l'andamento del carrello
    % ==========================================================================

    % Disegno la curva
    f  = @(x) (b./a.^2) .* x.^2 - (2.*b./a) .* x + b;
    figure();
    xrange = linspace(0, a);
    plot(xrange, f(xrange), 'linewidth', 2);
    grid();
    axis('equal');

    % Risolvo la ODE
    x0 = [0, 0]
    tspan = [0, 20];
    [t, x, v] = sim_cart(tspan, x0, a, b, g, m);

    % Disegno l'andamento della posizione
    figure();
    plot(t, x, 'linewidth', 2);
    grid();
    xlabel('Tempo', 'fontsize', 14);
    ylabel('Posizione', 'fontsize', 14);

    % ==========================================================================
    % Q2: determino i valori richiesti
    % ==========================================================================

    % Trovo l'indice del primo valore di x dopo il punto "a"
    last = find(x > a, 1); % L'1 rappresenta il numero di indici da restituire

    % Restringendomi al tratto del percorso prima del punto "a", calcolo il
    % tempo per arrivare al punto "a". Se tentassi il calcolo sull'intero
    % percorso, potrei avere problemi perche' lo stesso valore di x puo'
    % comparire piu' volte nel vettore
    ta = interp1(x(1:last), t(1:last), a)

    % Restringendomi al tratto del percorso prima del punto "a", calcolo la
    % velocita' nel punto "a"
    va = interp1(t(1:last), v(1:last), ta)

    % ==========================================================================
    % Q3: determino la posizione iniziale perché la velocità nel punto a sia vmin
    % ==========================================================================

    fz = @(c) speed_at_a(tspan, [c, 0], a, b, g, m) - vmin;
    [v0_sol, fval, flag] = fzero(fz, 0)

    % ==========================================================================
    % Q4: Implemento il metodo della bisezione e risolvo Q3 di nuovo
    % ==========================================================================

    [v0_sol2, fval2] = my_bisection(fz, v0_sol-1, 0)
end

function [x, fval] = my_bisection(f, x0, x1)
    tol = 1e-6;
    while true
        % Calcolo il prossimo valore di x
        x = 0.5 * (x0 + x1);
        fval = f(x);
        % Controllo se non sia il momento di terminare
        if abs(x - x0) <= tol
            break;
        end
        % Rimpiazzo x0 o x1
        if f(x0) * f(x) < 0
            x1 = x;
        else
            x0 = x;
        end
    end
end

function va = speed_at_a(tspan, x0, a, b, g, m)
    [t, x, v] = sim_cart(tspan, x0, a, b, g, m);
    last = find(x > a, 1);
    va = interp1(x(1:last), v(1:last), a);
end

function [t, x, v] = sim_cart(tspan, x0, a, b, g, m)
    dX = @(t, x) dstate(x, a, b, g, m)';
    [t, X] = ode45(dX, tspan, x0);
    x = X(:, 1);
    v = X(:, 2);
end

function dx = dstate(x, a, b, g, m)
    % x(1) = posizione x,
    % x(2) = velocita' tangenziale
    % Vettore forza di gravita
    G = m .* [0, -g];
    % Vettore tangente
    T = [1, (2.*b./a.^2) .* x(1) - 2.*b./a];
    % Versore tangente
    Tv = T / norm(T);
    % Vettore velocita'
    V = x(2) .* Tv;
    % Proiezione dell'accelerazione di gravita sul versore tangente
    % NOTA: basta l'intensita'
    Fg = G * Tv'; % NOTA: e' un prodotto scalare!
    % Calcolo le derivate
    dx(1) = V(1);
    dx(2) = Fg ./ m;
end