function es_heating3()
    % Un po' di dati intermedi
    g = 9.81;
    vA = 62; % Volume dell'aria
    vW = 0.25 * 16 * 2.7; % Volume dei muri
    mA = 1.225 * vA / g; % Massa dell'aria
    mW = 1050 * vW / g; % Massa dei muri

    % I veri e propri dati del problema
    CA = 1005 * mA; % Capacita' termica dell'aria
    CW = 1000 * mW; % Capacita' termica dei muri
    RCA = 0.35; % Resisitivita' termica convettore-aria
    RAW = 0.5; % Resistivita' termica aria-muro
    RWO = 3.0; % Resistivita' termica muro-esterno
    TC = 23; % Temperatura del convettore
    TO = 15; % Temperatura esterna
    TA0 = 19.5; % Temperatura dell'aria
    TW0 = 19.5; % Temperatura delle pareti

    % Simulo l'andamento della temperatura
    tspan = [0, 7200]; % Intervallo temporale
    x0 = [TA0, TW0]; % Stato iniziale
    [t, TA, TW] = simroom(tspan, x0, TA0, TW0, CA, CW, RCA, RAW, RWO, TC, TO);

    % Disegno l'andamento della temperatura dell'aria
    figure()
    plot(t, TA, 'linewidth', 2);
    grid()
end

function [t, TA, TW] = simroom(tspan, x0, TA0, TW0, CA, CW, RCA, RAW, RWO, TC, TO)
    % Funzione che definisce la ODE (deve restituire una colonna)
    dX = @(t, x) dstate(x, CA, CW, RCA, RAW, RWO, TC, TO)';
    % Risolvo la ODE
    [t, X] = ode45(dX, tspan, x0);
    % Estraggo del componenti dello stato
    TA = X(:, 1);
    TW = X(:, 2);
end

function dx = dstate(x, CA, CW, RCA, RAW, RWO, TC, TO)
    % x(1) = temperatura dell'aria, x(2) = temperature dei muri
    % Calcolo il valore dei flussi di calore
    wCA = 1/RCA * (TC - x(1));
    wAW = 1/RAW * (x(1) - x(2));
    wWO = 1/RWO * (x(2) - TO);
    % Calcolo la derivata delle due variabili di stato
    dx(1) = 1/CA * (wCA - wAW);
    dx(2) = 1/CW * (wAW - wWO);
end

