function es_tubes3()
    % Dati intermedi
    g = 9.81;
    S1 = 1; % Superfici
    S2 = 1;
    S3 = 1;
    h1 = 3; % Livelli dei serbatoi
    h2 = 2;
    h3 = 1;
    qmax12 = 0.0002; % Portata per unita' di pressione
    qmax23 = 0.0007;
    qmax31 = 0.0008;

    % Pressioni iniziali
    P1 = h1 * g;
    P2 = h2 * g;
    P3 = h3 * g;

    % Capacita'
    C1 = S1/g;
    C2 = S2/g;
    C3 = S3/g;

    % Resistenze
    R12 = 1/qmax12;
    R23 = 1/qmax23;
    R31 = 1/qmax31;

    % Simulo il sistema
    dX = @(t, x) dstate(x, C1, C2, C3, R12, R23, R31)';
    tspan = [0, 600];
    x0 = [P1, P2, P3];
    [t, X] = ode45(dX, tspan, x0);
    p1 = X(:, 1);
    p2 = X(:, 2);
    p3 = X(:, 3);

    % Disegno l'andamento delle tre pressioni
    figure();
    hold on
    plot(t, p1, 'linewidth', 2);
    plot(t, p2, 'linewidth', 2);
    plot(t, p3, 'linewidth', 2);
    hold off
    grid();

    % Pressione del serbatoio 1 dopo 600 secondi
    p1_600 = p1(end) % O anche: interp1(t, p1, 600)

    % Tempo necessario perche' la differenza tra p1 e p3 sia minore di 10^-1
    teq = interp1(abs(p1 - p2), t, 1e-1)
end

function dx = dstate(x, C1, C2, C3, R12, R23, R31)
    % x(1) = pressione serbatoio 1
    % x(2) = pressione serbatoio 2
    % x(3) = pressione serbatoio 3
    % Determino il valore corrente dei flussi
    q12 = 1/R12 * (x(1) - x(2));
    q23 = 1/R23 * (x(2) - x(3));
    q31 = 1/R31 * (x(3) - x(1));
    dx(1) = 1/C1 * (-q12+q31);
    dx(2) = 1/C2 * (q12-q23);
    dx(3) = 1/C3 * (q23-q31);
end