function es_moonshot()
    G = 6.67408e-11;
    ME = 5.972e24; % Massa della Terra
    MM = 7.34767309e22; % Massa della Luna
    MS = 800; % Massa del "satellite"
    rE = 6371e3; % Raggio della Terra
    rM = 1737e3; % Raggio della Luna
    D = 384400e3; % Distanza Terra-Luna

    % Simulo il lancio del satellite
    v0 = 11000; % Provare ance con 11100
                % Con v0 11100 la navicella raggiunge la Lune e quindi il suo
                % centro. Raggiunto il centro, l'attrazione gravitazionale
                % dovrebbe essere infinita (la legge di Newton perde senso
                % fisico)
    dX = @(t, x) dstate(x, G, ME, MS, MM, D)';
    tspan = [0, 3600 * 24 * 7];
    x0 = [rE, v0];
    [t, X] = ode45(dX, tspan, x0);
    x = X(:, 1);
    v = X(:, 2);

    % Disegno l'andamento della distanza dalla terra
    figure()
    plot(t, x, 'linewidth', 2);
    hold on
    plot(t, (D - rM) .* t.^0, 'linewidth', 2);
    hold off
    grid()

    % Determino la quota massima raggiunta
    highest = max(x)

    % Individuo se il satellite sia arrivato fino alla Luna
    ok = (highest > D - rM)
end

function dx = dstate(x, G, ME, MS, MM, D)
    % x(1) = altitudine, x(2) = velocita'
    % Calcolo la forza gravitazionale della terra sul satellite
    rSE = x(1);
    FSE = - G * ME * MS / (rSE * norm(rSE));
    % Calcolo la forza gravitazionale della luna sul satellite
    rSM = x(1) - D;
    FSM = - G * MM * MS / (rSM * norm(rSM));
    % Calcolo le derivate
    dx(1) = x(2);
    dx(2) = (FSE + FSM) / MS;
end

