function  es_bmw()
    rho = 1.25; % Densita' dell'aria
    A = 2.5 * 1.2;    % Superficie della seziojne
    C_D = 0.82; % Coefficiente di trascinamento
    M = 1539;   % Massa dell'auto
    F = 10000;  % Forza di accelerazione

    % Stato iniziale
    x0 = [0, 0];
    % Intervallo temporale
    tspan = [0, 60];
    % Funzione che definisce l'ODE
    % NOTA: il valore restituito deve essere una colonna, quindi
    % traspongo il risultato di "dstate"
    dX = @(t, x) dstate(x, rho, A, C_D, M, F)';
    % Risolvo l'equazione differenziale
    [T, X] = ode45(dX, tspan, x0);

    x = X(:, 1); % Posizioni visitate = prima colonna
    v = X(:, 2); % Velocita' visitate = seconda colonna

    % Disegno l'andamento della velocita'
    figure();
    plot(T, v, 'linewidth', 2)
    xlabel('Tempo', 'fontsize', 14)
    ylabel('Velocita', 'fontsize', 14)
    grid()

    % Ottengo il tempo necessario a raggiungere i 27.8 m/s
    t27_8 = interp1(v, T, 27.8)

    % Ottengo la strada percorsa nel tempo appena trovato
    v100 = interp1(T, x, t27_8)

    % Ottengo il valore della velocita' massima
    vmax = max(v)
end

function dx = dstate(x, rho, A, C_D, M, F)
	% x(1) = posizione, x(2) = velocita'
	% Calcolo la forza di attrito
	F_D = 0.5 .* rho .* x(2).^2 .* C_D .* A;
	% Calcolo la derivata della posizione
	dx(1) = x(2);
    % Calcolo la derivata della velocita'
	dx(2) = F ./ M - F_D ./ M;
end