function es_submarine()
    % Dati del problema
    g = 9.81;
    D = 3.5;
    H = 28.5;
    V = pi * (D/2)^2 * H; % Volume
    S = D * H * 1.8;
    Cd = 0.47;
    M = 222e3; % Massa
    rhoW = 1000; % Densita' dell'acqua
    L0 = V - M / rhoW; % Volume d'acqua iniziale (m^2)
    Tp = [     0,     10, 20, 180,      190, 200, 1800];
    Lp = [L0+0.3, L0+0.3, L0,  L0, L0-0.085,  L0,   L0];

    % Simulo il sottomarino
    dX = @(t, x) dstate(t, x, g, V, M, rhoW, Cd, S, Tp, Lp)';
    x0 = [-5, 0];
    tspan = [0, 1800];
    [t, X] = ode45(dX, tspan, x0);
    x = X(:, 1);
    v = X(:, 2);

    figure();
    plot(t, x, 'linewidth', 2);
    grid();

    % Determino la profondita' nei tempi richiesti
    x10 = interp1(t, x, 10*60)
    x20 = interp1(t, x, 20*60)
    x30 = interp1(t, x, 30*60)
end

function dx = dstate(t, x, g, V, M, rhoW, Cd, S, Tp, Lp)
    % x(1) = altitudine, x(2) = velocita'
    % Forza di galleggiamento
    Fb = g * rhoW * V;
    % Forza di gravità
    L = interp1(Tp, Lp, t); % Carico volumetrico d'acqua
    Fg = -(g*M + g*rhoW * L);
    % Trascinamento
    Ft = -0.5 * x(2) * abs(x(2)) * Cd * S * rhoW;
    % Calcolo le derivate
    dx(1) = x(2);
    dx(2) = (Fb+Fg+Ft) / (M + rhoW * L);
end
