function es_logi_eq()
    % Dati del problema
    r = 1.3;
    N = 10000;
    
    % Stato iniziale
    x0 = 1000;
    
    % Simulazione
    ftr = @(x, t) f(x, r, N);
    T = 1:100;
    X = simulate(ftr, T, x0);
    
    % Disegno l'andamento nel tempo
    figure();
    plot(T, X, 'linewidth', 2);
    grid();
end

function xf = f(xc, r, N)
    xf = r .* xc .* (1 - xc./N);
end