function es_logi_pp_eq()
    % Dati del problema
    r = 1.5;
    k = 1000;
    s = 0.010;
    u = 0.5;
    v = 0.3;

    % Stato iniziale
    x0 = [500, 30];
  
    % Simulazione
    ftr = @(x, t) f(x, r, k, s, u, v);
    T = 1:300;
    X = simulate(ftr, T, x0);
    
    % Disegno l'andamento della popolazione
    plot(T, X(:, 1), 'linewidth', 1.5);
    hold on
    plot(T, X(:, 2), 'r', 'linewidth', 1.5);
    hold off
    grid()
    
    % Disegno la traiettoria nello spazio degli stati
    figure();
    plot(X(:, 1), X(:, 2), 'linewidth', 1.5)
    grid()
    
    % Determino lo stato finale risolvendo un sistema di eq. non lineari
    feq = @(x) (x - f(x, r, k, s, u, v));
    [xeq, fval, flag] = fsolve(feq, [200, 30])
end

function xf = f(xc, r, k, s, u, v)
    % xc(1) --> prede
    % xc(2) --> predatori
    xf(1) = r .* (1 - xc(1)./k) .* xc(1) - (s .* xc(1)) .* xc(2);
    xf(2) = u .* xc(2) + v .* s .* xc(1) .* xc(2);
end