function es_logi_eq()
    % Dati del problema
    r = 1.3;  
    N = 10000;
    
    % Stato iniziale
    x0 = 1000;
    
    % Simulazione
    ftr = @(x, t) f(x, r, N);
    T = 1:100;
    X = simulate(ftr, T, x0);
    
    % Disegno l'andamento nel tempo
    figure();
    plot(T, X, 'linewidth', 2);
    grid();
    
    % Disegno l'andamento della funzione da azzerare
    feq = @(x) (x - f(x, r, N));
    x = linspace(0, N/2);
    plot_target_function(feq, x);
    
    % Determino lo stato finale risolvendo una equazione non lineare. In
    % questo caso si tratta di una equazione di secondo grado: potrebbe
    % essere risolve (ed in modo piu' efficiente) anche per via analitica
    [xeq, fval, flag] = fzero(feq, N)
end

function xf = f(xc, r, N)
    xf = r .* xc .* (1 - xc./N);
end