function es_dodge_metzner()
    % Valore del numero di Reynolds modificato
    Re_pl = 4300;
    
    % ***** Q1: n noto, f incognito
    n = 0.4; % Esponente della velocita' di deformazione (fluido pseudo-plastico)
    
    % Disegno la funzione (cosi' da avere una idea di come sia fatta)
    f1 = @(x) dodge_metzner(x, n, Re_pl); % Espongo solo il parametro "f"
                                          % della funzione "dodge_metzner"
    f_range = linspace(0, 0.01);
    plot_target_function(f1, f_range)
    
    % Trovo il valore esatto risolvendo una equazione non-lineare
    [sol_f, fval1, flag1] = fzero(f1, 0.0010)
    
    % ***** Q3: f noto, n incognito
    f = 0.0020;
    
    % Disegno la funzione (cosi' da avere una idea di come sia fatta)
    f2 = @(x) dodge_metzner(f, x, Re_pl); % Espongo solo il parametro "n"
                                          % della funzione "dodge_metzner"
    n_range = linspace(0.1, 1.2);
    plot_target_function(f2, n_range);
    
    % Trovo il valore esatto risolvendo una equazione non-lineare
    [sol_n, fval2, flag2] = fzero(f2, 0.5)
    
end

function z = dodge_metzner(f, n, Re_pl)
    z = 1./sqrt(f) - (4./n.^0.75) .* log(Re_pl .* f.^(1 - n./2)) + 0.4./n.^1.2;
end