function es_buckingham_reiner()
    % Dati del problema
    Re = 376;
    He = 113.1;
    
    % Disegno l'andamento della funzione da azzerare
    fn = @(f) buckingham_reiner(f, Re, He);
    f_range = linspace(0.001, 0.005, 100);
    plot_target_function(fn, f_range);
    
    % Determino il valore esatto risolvendo una equazione non lineare
    [sol_f, fval, flag] = fzero(fn, 0.001)
end

function z = buckingham_reiner(f, Re, He)
    z = f - (64./Re) .* (1 + (1./6).*(He./Re) - 64./3 * (He.^4./(f.^3.*Re.^7)));
end