function es_pump_location()
    % Dati del problema
    x0 = 0;
    x1 = 1000;
    y0 = 1322;
    y1 = 2131;

    % Disegno la funzione che rappresenta la somma delle distanze, data la
    % posizione del punto "a". Si nota che ha un solo minimo
    dist_a = @(a) dist(a, x0, x1, y0, y1); % Uso una funzione anonima per comodita'
    a_range = linspace(x0, x1);
    plot(a_range, dist_a(a_range), 'linewidth', 2);
    grid();
    xlabel('Posizione pompa', 'fontsize', 14);
    ylabel('Distanza delle utenze', 'fontsize', 14);
    
    % Costruisco funzione anonima che calcoli la derivata della somma delle
    % distanze, dato il valore di "a"
    ddist_a = @(a) ddist(a, x0, x1, y0, y1);
    
    % Trovo il valore di "a" che azzera la derivata. Come punto intermedio
    % sceglo quello a meta' tra x0 e x1
    [a_sol, fval, flag] = fzero(ddist_a, 0.5*(x0+x1))
end

% Definisco una funzione per il calcolo della distanza, dati i valori di
% tutti i parametri del problema
function d = dist(a, x0, x1, y0, y1)
	d1 = sqrt((x0 - a).^2 + y0.^2);
	d2 = sqrt((x1 - a).^2 + y1.^2);
	d = d1 + d2;
end

% Definisco una funzione per il calcolo della derivata della somma delle
% distanze, dati i valori di tutti i parametri del problema
function dd = ddist(a, x0, x1, y0, y1)
	dd1 = - (x0 - a) ./ sqrt((x0 - a).^2 + y0.^2);
	dd2 = - (x1 - a) ./ sqrt((x1 - a).^2 + y1.^2);
	dd = dd1 + dd2;
end