function es_beverton_holt_eq()
    % Dati del problema
    r = 1.58;
    N = 1000;
    x0 = 500; % Stato iniziale
    
    % Simulazione
    ftr = @(x, t) f(x, r, N);
    T = 1:100;
    X = simulate(ftr, T, x0);
    
    % Disegno l'andamento nel tempo
    plot(T, X, 'linewidth', 2);
    grid();
end

function xf = f(xc, r, N)
    xf = r .* xc ./ (1 + xc./N);
end
