function es_river_bank2()
    % Dati del problema
    x0 = 0;
    y0 = 0;
    y1 = 0;
    ymax = 3;
    s = 10.5;
    
    % Definisco la funzione da azzerare (che definische il sistema)
    fz = @(p) f(p, x0, y0, y1, ymax, s);
    [psol, fval, flag] = fsolve(fz, [-1, 1, 0, 3, 7])
    
    % Funzione anonima che descrive la curva
    g = @(x) polyval(psol(1:3), x);
    
    % Disegno l'andamento della curva
    x = linspace(x0, psol(5));
    plot(x, g(x), 'linewidth', 2);
    grid()
    axis('equal'); % stessa scala sui due assi
end

function z = f(p, x0, y0, y1, ymax, s)
    % "p" e' il vettore con le variabili del sistema
    % p(1) = coefficiente di x^2 nella curva
    % p(2) = coefficiente di x nella curva
    % p(3) = coefficiente di 1 nella curva
    % p(4) = posizione del massimo
    % p(5) = posizione dell'estremo di destra
    
    % La curva deve passare per (x0, y0)
    z(1) = p(1)*x0^2 + p(2)*x0 + p(3) - y0;
    % La curva deve passare per (p(5), y1)
    z(2) = p(1)*p(5)^2 + p(2)*p(5) + p(3) - y1;
    % La derivata si deve annullare in p(4)
    z(3) = 2*p(1)*p(4) + p(2);
    % in p(4) la curva deve valere ymax
    z(4) = p(1)*p(4)^2 + p(2)*p(4) + p(3) - ymax;
    % l'integrale della curva tra x0 e p(5) deve valere s
    z(5) = 1/3*p(1)*p(5)^3 + 1/2*p(2)*p(5)^2 + p(3)*p(5) - s;
end