function es_isentropic()
    % Dati del problema
	g = 9.81;
	R = 8.31;
	p0 = 1;
	T0 = 295;
	z0z = -10;
	T = 257.7;
	p = 0.65;
    
    % Definisco una funzione anonima che esponga solo i parametri di
    % interesse.
    % Convenzione: x(1) ? gm, x(2) ? M
    f2 = @(x) f(p, T, p0, T0, x(1), x(2), z0z, R, g);
    
    % Trovo il valore della massa e della costante caratteristica del gas
    % risolvendo un sistema di equazioni non lineari
    [sol, fval, flag] = fsolve(f2, [1.4, 20])
end


function z = f(p, T, p0, T0, gm, M, z0z, R, g)
    % La pressione ? determinata da una formula nota:
    z(1) = p - p0 .* (1 + (1 - 1./gm) .* M ./ (R.*T0) .* g .* z0z).^(gm ./ (gm-1));
    % La temperatura ? determinata da una formula nota:
    z(2) = T - T0 .* (1 + (1 - 1./gm) .* M ./ (R.*T0) .* g .* z0z);
end