function es_beverton_holt_eq()
    % Dati del problema
    r = 1.58;
    N = 1000;
    x0 = 500; % Stato iniziale
    
    % Simulazione
    ftr = @(x, t) f(x, r, N);
    T = 1:100;
    X = simulate(ftr, T, x0);
    
    % Disegno l'andamento nel tempo
    plot(T, X, 'linewidth', 2);
    grid();
    
    % Disegno l'andamento della funzione da azzerare
    feq = @(x) (x - f(x, r, N));
    x = linspace(0, 2*N);
    plot_target_function(feq, x);
    
    % Determino lo stato finale risolvendo una equazione non lineare. In
    % questo caso si tratta di una equazione di secondo grado: potrebbe
    % essere risolve (ed in modo piu' efficiente) anche per via analitica
    [xeq, fval, flag] = fzero(feq, x0)
end

function xf = f(xc, r, N)
    xf = r .* xc ./ (1 + xc./N);
end
