function es_shepherd_eq()
    % Dati del problema
    r = 1.72;
    k = 1000;

    % Stato iniziale
    x0 = 100;
  
    % Simulazione
    ftr = @(x, t) f(x, r, k);
    T = 1:100;
    X = simulate(ftr, T, x0);
    
    % Disegno l'andamento della popolazione
    figure()
    plot(T, X, 'linewidth', 2);
    grid();
    
    % Disegno l'andamento della funzione da azzerare
    feq = @(x) (x - f(x, r, k));
    x = linspace(0, 3*k);
    plot_target_function(feq, x);
    
    % Determino lo stato finale risolvendo una equazione non lineare (di
    % terzo grado, in questo caso)
    [xeq, fval, flag] = fzero(feq, r*k)
end

function xf = f(xc, r, k)
    xf = (r .* xc) ./ (1 + (xc./k).^2);
end