clear all

% Dati del problema
x0 = 0;
x1 = 30;
d0 = 0;
d1 = 0;
s1 = 120;

% Impostazione del sistema di eq. lineari
A = [    x0^2,       x0, 1;
         x1^2,       x1, 1;
     1/3*x1^3, 1/2*x1^2, x1];
b = [d0; d1; s1];

% Risolvo il sistema
p = A \ b;

f = @(x) polyval(p, x);

% Disegno la sezione
x = linspace(x0, x1);
plot(x, f(x), 'linewidth', 2);
grid()
xlabel('Posizione', 'fontsize', 14)
ylabel('Profondita', 'fontsize', 14)
axis('equal') % Stessa scala per i due assi (per avere proporzioni realistiche)

% Determino la massima profondita'
xmax = -p(2) / (2*p(1)); % Trovo la posizione del massimo per via analitica
dmax = f(xmax)