clear all

% Dati del problema
t0 = 0;
t1 = 2;
v0 = 5.5;
v1 = 0;
s1 = 3;

% Impostazione della soluzione
A = [    t0^3,     t0^2,       t0,  1; % Velocita' iniziale
         t1^3,     t1^2,       t1,  1; % Velocita' finale
       3*t1^2,     2*t1,        1,  0; % Derivata della velocita' finale
     1/4*t1^4, 1/3*t1^3, 1/2*t1^2, t1] % Spazio percorso
b = [v0; v1; 0; s1];

p = A \ b   % Trovo i parametri della curva di controllo della velocita'

% Funzione che corrisponde alla curva
f = @(t) polyval(p, t);

% Disegno il profilo di velocita'
t = linspace(t0, t1);
plot(t, f(t), 'linewidth', 2);
grid()
xlabel('Tempo', 'fontsize', 14)
ylabel('Velocita', 'fontsize', 14)
