clear all

% Dati del problema
x0 = 0;
x1 = 2;
x2 = 6;
y0 = 3;
y2 = 0;

% Trovo i parametri della curva
A = [x0^2, x0, 1;
     x2^2, x2, 1;
     2*x1,  1, 0];
b = [y0; y2; 0];

p = A \ b % Parametri della curva (una parabola)

f = @(x) polyval(p, x);

% Disegno la curva
x = linspace(x0, x2);
plot(x, f(x), 'linewidth', 2);
grid()

% Determino l'altezza massima
ymax = f(x1);
fprintf('Altezza massima = %.2f\n', ymax);


