function es_pagerank_eq()
    % Probabilita' di ri-iniziare
    p = 0.1;
    % Probabilita' di passare ad una pagina adiacente
    P = [ 0.0, 1.0, 0.5;
          0.5, 0.0, 0.5;
          0.5, 0.0, 0.0];
    % Ottengo (indirettamte) il numero di pagine
    n = length(P); % length = max tra numero di righe e di colonne
    
    % Definisco lo stato iniziale
    x0 = 1/n * ones(1, n);
    
    % Definisco la matrice di transizione
    A = (1-p) * P;
    b = p * (1/n) * ones(n, 1);
    
    % Simualzione
    f2 = @(xc, t) f(xc, t, A, b);
    T = 1:10;
    X = simulate(f2, T, x0);
    
    % Disegno la distribuzione di probabilita' finale
    bar(X(end, :));
    
    % Disegno l'andamento delle probabilita
    figure();
    bar3(X)
    
    % Determino la distribuzione di probabilita' finale risolvendo un
    % sistema di equazioni lineari
    det(eye(3) - A)  % Anche se questo e' un modello probabilistico la 
                     % matrice e' non singolare (visto che ogni tanto lo
                     % stato da in "reset")
    xeq = (eye(3) - A) \ b
    
    % Visualizzo l'ultimo stato simulato
    X(end, :)
end


function xf = f(xc, t, A, b)
    xf = A* xc' + b;
    xf = xf';
end