function [a, MSE] = check_Newton(DGAMMA, TAU)
    DGAMMA = DGAMMA';
    TAU = TAU';
    A = [DGAMMA];
    X = A \ TAU;

    % Estraggo i parametri
    a = X(1);
    
    f = @(dgamma) X .* dgamma;
    
    MSE = sum((TAU - f(DGAMMA)).^2) ./ length(DGAMMA);
    
    figure()
    dgamma = linspace(min(DGAMMA), max(DGAMMA));
    plot(dgamma, f(dgamma));
    hold on
    scatter(DGAMMA, TAU);
    hold off
end