function [a, b, MSE] = check_Bingham(DGAMMA, TAU)
    DGAMMA = DGAMMA';
    TAU = TAU';
    A = [DGAMMA, DGAMMA.^0];
    X = A \ TAU;

    % Estraggo i parametri
    a = X(1);
    b = X(2);
    
    f = @(dgamma) polyval(X, dgamma);
    
    MSE = sum((TAU - f(DGAMMA)).^2) ./ length(DGAMMA);
    
    figure()
    dgamma = linspace(min(DGAMMA), max(DGAMMA));
    plot(dgamma, f(dgamma));
    hold on
    scatter(DGAMMA, TAU);
    hold off
end