function [a, b, MSE] = check_PowerLaw(DGAMMA, TAU)
    DGAMMA = DGAMMA';
    TAU = TAU';
    
    % Approssiomo le relazione tra le grandezze trasformate
    A = [DGAMMA.^0, log(DGAMMA)];
    X = A \ log(TAU);
    
    % Calcolo il valore dei parametri nella scala originale
    a = X(2); % Questo e' il parametro a
    b = exp(X(2)); % Questo e' il parametro b
    
    f = @(dgamma) (b .* dgamma.^a);
    
    MSE = sum((TAU - f(DGAMMA)).^2) ./ length(DGAMMA);
    
    figure()
    dgamma = linspace(min(DGAMMA), max(DGAMMA));
    plot(dgamma, f(dgamma));
    hold on
    scatter(DGAMMA, TAU);
    hold off
end