function es_tubes2_eq()
    % Dati intermedi
    g = 9.81;
    S1 = 1; % Superfici
    S2 = 1;
    h1 = 3; % Livelli dei serbatoi
    h2 = 1;
    qp12 = 0.005; % Portata per unita' di pressione
    qp23 = 0.003;
    
    % Pressioni iniziali
    P1 = h1 * g;
    P2 = h2 * g;
    PO = 1.013;
    
    % Capacita'
    C1 = S1/g;
    C2 = S2/g;
    
    % Resistenze
    R12 = 1/qp12;
    R23 = 1/qp23;
    
    % Flusso in ingresso
    qin = 0.001;

    % Descrizione dello stato:
    % 1: pressione serbatoio 1
    % 2: pressione serbatoio 2
    % 3: flusso in ingresso
    % 4: flusso da 1 a 2
    % 5: flusso da 2 a 3 (esterno)
    x0 = [P1, P2, 0, 0, 0]; % I flussi prenderanno il valore corretto dal secondo passo
    
    % Matrice di transizione di stato
    A = [    1,      0, 1/C1, -1/C1,     0;
             0,      1,    0,  1/C2, -1/C2;
             0,      0,    0,     0,     0;
         1/R12, -1/R12,    0,     0,     0;
             0,  1/R23,    0,     0,     0];
    
    % Influsso costante
    b = [0; 0; qin; 0; 0];
    
    % Simulazione
    f2 = @(xc, t) f(xc, t, A, b);
    T = 1:600;
    X = simulate(f2, T, x0);
    
    % Disegno l'andamento delle pressioni
    figure()
    plot(T, X(:, 1), 'b')
    hold on
    plot(T, X(:, 2), 'r')
    hold off
end

function xf = f(xc, t, A, b)
    xf = A*xc' + b;
    xf = xf';
end