function es_weather_eq()
    % Definisco la matrice di transizione
    A = [0.9, 0.5;
         0.1, 0.5];
    
    % Stato iniziale    
    x0 = [0, 1];
    
    % Simulo
    ftr = @(xc, t) f(xc, t, A);
    T = 1:30;
    X = simulate(ftr, T, x0);
    
    % Disegno l'andamento delle probabilita'
    figure()
    hold on
    plot(T, X(:, 1), 'b')
    plot(T, X(:, 2), 'r')
    hold off
    
    % Determino lo stato di equilibrio
    A2 = [eye(2) - A;
          ones(1, 2)];
    b = [0; 0; 1];
    xeq = linsolve(A2, b)
end


function xf = f(xc, t, A)
    xf = A * xc';
    xf = xf';
end