clear all

% Temperatura (?C)
T = [-20, -5, 2.1, 10.3, 24, 32.4, 43.8, 61.4, 80.3, 100.6];
% Pressione (Torr)
P = [1, 5, 10, 20, 40, 60, 100, 200, 400, 760];
% Temperatura di fusione
Tf = 8.2;
% Trasformo le temperature in ?K
T = T + 273.15;
Tf = Tf + 273.15;

% Considero i punti sopra la temperatura di fusione
T2 = T(T > Tf)
P = P(T > Tf)
T = T2 % Rimpiazzo T

% Usiamo una approssimazione ai minimi quadrati
T = T'; % T come vettore colonna
P = P'; % P come vettore colonna
A = [T.^0, -1./T]; % Costruisco la matrice per impostare le equazioni normali
x = A \ log(P); % Se A ? rettangola, la divisione sx in Matlab risolve un
                % problema ai minimi quadrati

a = x(1) 
b = x(2) 

% Funzione anonima, per semplificare il disegno
f = @(T) exp(a -b./T);

figure()
plot(t, f(t), 'linewidth', 2);
hold on
scatter(T, P, 'linewidth', 2);
hold off
grid()
xlabel('T')
ylabel('P')
title('Minimi quadrati, grandezze trasformate');