function es_warehouse_prob2()
    % Dati del problema
    n = 10; % Capacita' del magazzino
    p = 0.1; % Probabilita' di vendita
    h = 57; % Tempo prima del riempimento (dopo 56 giorni la probabilita'
            % di svuotamento e' del 5% circa

    % Una probabilita' per ogni livello: il primo livello (posizione 1)
    % corrisponde alla capacita' 0. Il livello n+1 alla capacita' piena.
    % All'inizio, il magazzino e' completamente pieno
    x0 = [zeros(1, n), 1];
    
    % Definisco la matrice di transizione
    A = zeros(n, n);
    A(1,1) = 1; % Una volta raggiunto il livello 1, vi si rimane
    for ii = 2:n+1
        A(ii,ii) = 1-p; % Il livello resta costante
        A(ii-1,ii) = p; % Probabilita' di passare dal livello ii a ii-1
    end
    
    % Simulo per h-1 passi (fino ad appena prima del riempimento)
    f2 = @(xc, t) f(xc, t, A);
    T = 1:h-1;
    X = simulate(f2, T, x0);
    
    % Distribuzione di probabilita' appena prima del riempimento
    bar(X(end, :))
    
    % Evoluzione dello stato (distribuzioni di probabilitaa')
    figure();
    bar3(X);
    xlabel('Livello (1 = cap. 0)');
    ylabel('Tempo');
end

function xf = f(xc, t, A)
    xc = xc';
    xf = A * xc;
    xf = xf';
end