function es_warehouse_prob2()
    % Dati del problema
    n = 3; % Capacita' del magazzino
    p = 0.1; % Probabilita' di vendita
    h = 10; % Tempo prima del riempimento

    % Una probabilita' per ogni livello: il primo livello (posizione 1)
    % corrisponde alla capacita' 0. Il livello 4 alla capacita' piena.
    % All'inizio, il magazzino e' completamente pieno
    x0 = [0, 0, 0, 1];
    
    % Definisco la matrice di transizione
    A = [1,   p,   0,   0;
         0, 1-p,   p,   0;
         0    0, 1-p,   p;
         0,   0,   0, 1-p];
    
    % Simulo per h-1 passi (fino ad appena prima del riempimento)
    f2 = @(xc, t) f(xc, t, A);
    T = 1:h-1;
    X = simulate(f2, T, x0);
    
    % Distribuzione di probabilita' appena prima del riempimento
    bar(X(end, :))
    
    % Evoluzione dello stato (distribuzioni di probabilitaa')
    figure()
    bar3(X);
    xlabel('Livello (1 = cap. 0)');
    ylabel('Tempo');
end

function xf = f(xc, t, A)
    xc = xc';
    xf = A * xc;
    xf = xf';
end