function es_heating3()
    % Un po' di dati intermedi
    vA = 62; % Volume dell'aria
    vW = 0.20 * 16 * 2.7; % Volume dei muri
    mA = 1.225 * vA; % Massa dell'aria
    mW = 1050 * vW; % Massa dei muri
    
    % I veri e propri dati del problema
    CA = 1005 * mA; % Capacita' termica dell'aria
    CW = 840 * mW; % Capacita' termica dei muri
    RTA = 2.0; % Resistivita' termica termosifone-aria
    RTW = 0.2; % Resistivita' termica termosifone-muro
    RAW = 0.4; % Resistivita' termica aria-muro
    RWO = 4.0; % Resistivita' termica muro-esterno
    TT = 55; % Temperatura dei termosifoni
    TO = 15; % Temperatura esterna
    TA = 19.5; % Temperatura dell'aria
    TW = 19.5; % Temperatura delle pareti
    
    % Descrizione dello stato
    % 1: temperatura dell'aria
    % 2: temperatura dei muri
    % 3: flusso di calore dal termosifone all'aria
    % 4: flusso di calore dal termosifone ai muri
    % 5: flusso di calore dall'aria ai muri
    % 6: flusso di calore dai muri all'esterno
    x0 = [TA, TW, 0, 0, 0, 0];
    
    % Definisco la matrice di transizione
    A = [      1,      0,  1/CA,     0, -1/CA,     0;
               0,      1,     0,  1/CW, +1/CW, -1/CW;
          -1/RTA,      0,     0,     0,     0,     0;
               0, -1/RTW,     0,     0,     0,     0;
           1/RAW, -1/RAW,     0,     0,     0,     0;
               0,  1/RWO,     0,     0,     0,     0];
    
    % Definisco il termine noto
    b = [0; 0; 1/RTA*TT; 1/RTW*TT; 0; -1/RWO*TO];
            
    % Simulazione
    ftr = @(xc, t) f(xc, t, A, b);
    T = 1:3600*4;
    X = simulate(ftr, T, x0);
    
    % Disegno l'andamento dello due temperature
    plot(T, X(:, 1), 'b');
    hold on
    plot(T, X(:, 2), 'r');
    hold off
end


function xf = f(xc, t, A, b)
    % Calcolo lo stato futuro
    xf = A * xc' + b;
    xf = xf';
end