function es_termodinamica()
    % Coefficienti per il calcolo del calore molare
    p = [8.8551E-08, -4.1950E-04, 7.7121E-01, -6.096]; % Stato gassoso
    z = 273.15; % Offset dello 0 C rispetto allo 0 K
    
    % Esempio di calcolo del calore molare a 25 gradi Celsius
    cmol25 = polyval(p, 25 + z)
    
    % Differenza di entalpia, stato liquido
    P = polyint(p); % Integrale del calore molare (un altro polinomio)
    
    % Calcolo della differenza di entalpia tra 25 e 100 gradi 
    dH = polyval(P, 450 + z) - polyval(P, 25 + z)
    
    % Calcolo e disegno il valore del calore molare per vari livelli di
    % temperatura
    T = linspace(25, 400, 200);
    cstar = polyval(p, T);
    plot(T, cstar);
end



