function es_heating()
    % Un po' di dati intermedi
    g = 9.81;
    vA = 62; % Volume dell'aria
    vW = 0.25 * 16 * 2.7; % Volume dei muri
    mA = 1.225 * vA / g; % Massa dell'aria
    mW = 1050 * vW / g; % Massa dei muri
    
    % I veri e propri dati del problema
    CA = 1005 * mA; % Capacita' termica dell'aria
    CW = 1000 * mW; % Capacita' termica dei muri
    RCA = 0.2; % Resisitivita' termica convettore-aria
    RAW = 0.4; % Resistivita' termica aria-muro
    RWO = 2.0; % Resistivita' termica muro-esterno
    WCA = 10; % Flusso di calore dal convettore
    TO = 15; % Temperatura esterna
    TA = 19.5; % Temperatura dell'aria
    TW = 19.5; % Temperatura delle pareti
    
    % Descrizione dello stato
    % 1: temperatura dell'aria
    % 2: temperatura dei muri
    % 3: flusso di calore di ingresso all'aria
    % 4: flusso di calore dall'aria ai muri
    % 5: flusso di calore dai muri all'esterno
    x0 = [19.5, 19.5, WCA, 1/RAW*(TA-TW), 1/RWO*(TW-TO)];
    
    % Definisco la matrice di transizione
    A = [      1,      0,  1/CA, -1/CA,     0;
               0,      1,     0,  1/CW, -1/CW;
          	   0,      0,     0,     0,     0;
           1/RAW, -1/RAW,     0,     0,     0;
               0,  1/RWO,     0,     0,     0;];
    
    % Definisco il termine noto
    b = [0; 0; WCA; 0; -1/RWO*TO];
            
    % Simulazione
    ftr = @(xc, t) f(xc, t, A, b);
    T = 1:7200;
    X = simulate(ftr, T, x0);
    
    % Disegno l'andamento dello due temperature
    plot(T, X(:, 1), 'b');
    hold on
    plot(T, X(:, 2), 'r');
    hold off
end


function xf = f(xc, t, A, b)
    % Calcolo lo stato futuro
    xf = A * xc' + b;
    xf = xf';
end