function es_weather()
    % Definisco la matrice di transizione
    A = [0.9, 0.5;
         0.1, 0.5];
    
    % Stato iniziale    
    x0 = [0, 1];
    
    % Simulo
    ftr = @(xc, t) f(xc, t, A);
    T = 1:30;
    X = simulate(ftr, T, x0);
    
    % Disegno l'andamento delle probabilita'
    figure()
    hold on
    plot(T, X(:, 1), 'b')
    plot(T, X(:, 2), 'r')
    hold off
end


function xf = f(xc, t, A)
    xf = A * xc';
    xf = xf';
end