function es_tubes()
    % Dati intermedi
    g = 9.81;
    S1 = 1; % Superfici
    S2 = 1;
    S3 = 1;
    h1 = 3; % Livelli dei serbatoi
    h2 = 2;
    h3 = 1;
    qmax12 = 0.0002; % Portata per unita' di pressione
    qmax23 = 0.0007;
    qmax31 = 0.0008;
    
    % Pressioni iniziali
    P1 = h1 * g;
    P2 = h2 * g;
    P3 = h3 * g;
    
    % Capacit?
    C1 = S1/g;
    C2 = S2/g;
    C3 = S3/g;
    
    % Resistenze
    R12 = 1/qmax12;
    R23 = 1/qmax23;
    R31 = 1/qmax31;

    % Descrizione dello stato:
    % 1: pressione serbatoio 1
    % 2: pressione serbatoio 2
    % 3: pressione serbatoio 3
    % 4: flusso da 1 a 2
    % 5: flusso da 2 a 3
    % 6: flusso da 3 a 1
    x0 = [P1, P2, P3, 1/R12*(P1-P2), 1/R23*(P2-P3), 1/R31*(P1-P3)];
    
    % Matrice di transizione di stato
    A = [     1,      0,      0, -1/C1,     0,  1/C1;
              0,      1,      0,  1/C2, -1/C2,     0;
              0,      0,      1,     0,  1/C3, -1/C3;
          1/R12, -1/R12,      0,     0,     0,     0;
              0,  1/R23, -1/R23,     0,     0,     0;
         -1/R31,      0,  1/R31,     0,     0,     0];
    
    % Simulazione
    ftr = @(xc, t) f(xc, t, A);
    T = 1:600;
    X = simulate(ftr, T, x0);
    
    % Disegno l'andamento delle pressioni
    % NOTA: le pressioni diventano nel tempo identiche fra di loro, perche'
    % i livelli dei tre serbatoio diventano identici. All'inizio il
    % serbatoio 2 tende a svuotarsi, perche' riceva acqua solo dal
    % serbatoio 1, che ha una condotta di uscita con un valore di qmax
    % molto basso
    figure()
    plot(T, X(:, 1), 'b')
    hold on
    plot(T, X(:, 2), 'r')
    plot(T, X(:, 3), 'g')
    hold off
end


function xf = f(xc, t, A)
    xf = A*xc';
    xf = xf';
end