function es_polynomials()
    p = [1, -2, 1.5];
    
    % Calcolo il valore del polinomio in 0
    y0 = my_polyval(p, 0)
    y0_ref = polyval(p, 0)
    
    % Calcolo la derivata (un altro polinomio)
    dp = my_polyder(p)
    dp_ref = polyder(p)
    
    % Calcolo l'integrale (un altro polinomio)
    P = my_polyint(p)
    P_ref = polyint(p)
end


function y = my_polyval(p, x)
    % Determino il grado del polinomio
    n = length(p)-1;
    % Calcolo i termini monomiali [x^n, x^(n-1), x^(n-2), ...]
    m = x.^(n:-1:0); % Notate l'elevamento a potenza elemento per elemento
    % Calcolo il risultato [p(n) * x^n, p(n-1) * x^(n-1), ...]
    y = sum(p .* m); % Notatate il prodotto elemento per elemento
end


function dp = my_polyder(p)
    % Determino il grado del polinomio
    n = length(p)-1;
    % Elimino l'ultimo termine del polinomio (si azzera derivando)
    dp = p(1:end-1);
    % Calcolo i coefficienti per cui moltiplicare i termini del polinomio.
    c = n:-1:1;
    % Calcolo la derivata (un nuovo polinomio)
    dp = dp .* c; % notate la moltiplicazione elemento per elemento
end


function P = my_polyint(p)
    % Determino il grado del polinomio
    n = length(p)-1;
    % Calcolo i coefficienti per cui dividere i termini del polinomio.
    c = n+1:-1:1;
    % Calcolo il risultato (a meno del termine costante)
    P = p ./ c;
    % Aggiungo uno zero
    P = [P, 0];
end