function es_particle_prob()
    A = [0.75, 0.50, 0.00;
         0.25, 0.25, 0.75;
         0.00, 0.25, 0.25];

    % Definisco lo stato inziale: un valore di probabilita' per ogni stato
    x0 = [1, 0, 0];
    
    % Simulo
    ftr = @(xc, t) f(xc, t, A);
    T = 1:10;
    X = simulate(@f, T, x0);
    
    % Distribuzione di probabilita' finale
    bar(X(end, :))
    
    % Evoluzione dello stato (distribuzioni di probabilitaa')
    % NOTA: questo passo non era richiesto dall'esercizio
    figure()
    bar3(X);
    xlabel('Livello');
    ylabel('Tempo');
    
    % Determinazione dello stato finale mediante un sistema lineare
    Amod = [eye(3) - A;
            1, 1, 1]
    b = [0; 0; 0; 1]
    xeq = linsolve(Amod, b)
end


function xf = f(xc, t, A)
    xc = xc'; % Stato corrente come vettore colonna
    xf = A * xc; % Stato futuro come vettore colonna
    xf = xf'; % Stato futuro come vettore colonna
end