function es_warehouse_stoch()
    x0 = 10;
    
    T = 1:500;
    xc = x0;
    for t = T
        X(t) = xc;
        xc = f(xc, t);
    end
    X(end) = xc; % Salvo l'ultimo valore dello stato
    
    % Disegno l'andamento del livello del magazzino
    plot(T, X);
    
    % Disegno l'istrogramma dello stato (capacit? del magazzino)
    histogram(X, 11); % 11 intervalli nell'istrogramma
end

function xf = f(xc, t)
    % Modello il rimpiemento
    if mod(t, 15) == 0
        xf = 10;
        return;
    end

    % Modello gli ordini. Se il magazzino e' vuoto, rimane vuoto
    if xc == 0
        xf = 0;
    else
        % Altrimenti, c'e il 10% di probabilita' che il livello cali
        if randi(10, 1) == 1
            xf = xc - 1;
        else
            xf = xc;
        end
    end
end