function es_shepherd()
    % Stato iniziale
    x0 = 100;
  
    % Simulazione
    T = 1:100;
    xc = x0;
    for t = T
        X(t) = xc;
        xc = f(xc);
    end
    X(end) = xc; % Salvo l'ultimo valore dello stato
    
    % Disegno l'andamento della popolazione
    figure()
    plot(T, X);
end

function xf = f(xc)
    r = 1.5; % Minimo valore di r tale che la popolazione si assesta su k
    k = 1000;
    xf = (r .* xc) ./ (1 + (xc./k).^2);
end