function es_logi_pp()
    % Stato iniziale
    x0 = [500, 30]; % Al variare del numero di predatori, il sistema
                     % converge sempre verso lo stesso stato finale. Il
                     % modello pu? per? perdere di senso fisico (alcuni
                     % valori di popolazione diventano negativi)
  
    % Simulazione
    T = 1:500;
    xc = x0;
    for t = T
        X(t, :) = xc; % Memorizzo lo stato corrente
        xc = f(xc);
    end
    X(end, :) = xc; % Memorizzo lo stato finale
    
    % Disegno l'andamento della popolazione
    plot(T, X(:, 1), 'linewidth', 1.5);
    hold on
    plot(T, X(:, 2), 'r', 'linewidth', 1.5);
    hold off
    
    % Disegno la traiettoria nello spazio degli stati
    figure();
    plot(X(:, 1), X(:, 2), 'linewidth', 1.5)
end

function xf = f(xc)
    % xc(1) --> prede
    % xc(2) --> predatori
    r = 1.5;
    k = 1000;
    s = 0.010;
    u = 0.5;
    v = 0.3;
    xf(1) = r * (1 - xc(1)/k) * xc(1) - (s * xc(1)) * xc(2);
    xf(2) = u * xc(2) + v * s * xc(1) * xc(2);
end

% COMMENTI SULLE VARIAZIONI
% Aumentando s, si aumenta la capacit? di predare dei predatori
% - Il sistema tende a perdere senso fisico, perch? il numero di prede
%   diventa in molti casi negativo
% - Se l'aumento ? sufficientemente piccolo, il numero finale di prede
%   tende a diminuire (come ? intuitivo che succeda)
% - Se s diventa troppo piccolo, i predatori non riescono a sopravvivere
% - Se s cala di molto poco, il numero finale di prede aumenta e quello di
%   predatori diminuisce
%
% Aumentando r si aumenta la capacit? riproduttiva delle prede
% - Il numero di prede tende a variare in modo pi? brusco e cosi anche
%   quello dei predatori. Ci vogliono pi? passi perch? il sistema si
%   assesti
% - Quando r ragginge il valore 2 il sistema diventa periodico
% - Se r cresce ancora, si tende a perdere il senso fisico (oscillazioni
%   troppo grandi)
% - Se r cala, le prede si riproducono troppo lentamente ed i predatori
%   (fatto interessante) non riescono a sopravvivere
% - Se r cala troppo, si perde il senso fisico
%
% Aumentando u, si aumenta la capacit? dei predatori di sopravvivere senza
% prede.
% - In generale, il numero di predatori tende ad aumentare e quello di
%   prede a diminuire
% - Se u divente troppo grande si perde il senso fisico
% - Se u cala, il numero finale di predatori diminuisce, ma solo
%   leggermente. La diminuzione ? leggera perch? aumenta invece di molto il
%   numero finale di prede (quindi in qualche modo i predatori
%   sopravvivono)