function es_electron_stoch()
    % Stato iniziale
    x0 = 1;
  
    % Simulazione
    T = 1:1000;
    xc = x0;
    for t = T
        X(t) = xc;
        xc = f(xc);
    end
    X(end) = xc; % Salvo l'ultimo valore dello stato
    
    % Disegno l'andamento dello stato
    figure()
    plot(T, X);
    
    % Visualizzo l'istogramma dei valori dello stato
    figure()
    histogram(X, 3); % 3 intervalli nell'istogramma
end

function xf = f(xc)
    % Genero un numero pseudo-casuale
    r = unifrnd(0, 1, 1);
    if xc == 1
        if r < 0.75
            xf = xc;
        else
            xf = xc + 1;
        end
    end
    if xc == 2
        if r < 0.25
            xf = xc;
        else
            if r < 0.75
                xf = xc-1;
            else
                xf = xc+1;
            end
        end
    end
    if xc == 3
        if r < 0.75
            xf = xc-1;
        else
            xf = xc;
        end
    end
end