function es_drunkman()
    % Stato (posizione) iniziale
    x0 = [0, 1];
    
    % Simulazione
    T = 1:1000;
    xc = x0;
    for t = T
        X(t, :) = xc; % Memorizzo lo stato corrente (riga)
        xc = f(xc); % Determino lo stato futuro
    end
    X(end, :) = xc; % Memorizzo l'ultimo stato visitato (riga)
    
    % Disegno l'andamento dello stato nel tempo (due variabili)
    figure();
    plot(T, X(:, 1)); % Prima colonna (posizione)
    hold on
    plot(T, X(:, 2)); % Seconda colonna (direzione dell'ultimo spostamento)
    hold off
end

function xf = f(xc)
    p = 0.8;
    % Determino la direzione di movimento
    r = unifrnd(0, 1, 1);
    if r < p
        d = xc(2); % Stessa direzione
    else
        d = -xc(2); % Cambio di direzione
    end
    % Determino il prossimo stato
    xf(1) = xc(1) + d;
    xf(2) = d;
end