clear all

% Importo i dati da un foglio excel
data = xlsread('wine.xlsx');

% Separo le colonne e le inserisco in variabili distinte
Alcol = data(:, 1);
AcidoMalico = data(:, 2);
Ceneri = data(:, 3);
Magnesio = data(:, 4);
Fenoli = data(:, 5);
Flavonoidi = data(:, 6);
IntColore = data(:, 7);
Tinta = data(:, 8);

% Istogramma della percentuale di alcol
figure();
histogram(Alcol, 20);
title('Istogramma della percentuale di alcol');

% Media della percentuale di alcol
alcol_mean = mean(Alcol)

% Deviazione standard della percentuale di alcol
alcol_std = std(Alcol)

% Mediana della percentuale di alcol
alcol_med = median(Alcol)

% Una correlazione debole che coinvolge l'alcol
figure();
scatter(Alcol, IntColore);
title('Correlazione alcol -- int. colore')
xlabel('Alcol');
ylabel('Intensit? Colore');

% Una correlazione forte che coinvolte i flavonoidi
figure();
scatter(Fenoli, Flavonoidi);
title('Correlazione fenoli -- flavonoidi')
xlabel('Fenoli');
ylabel('Flavonoidi');
