function random_walk_prob()
    % Configurazione
    n = 9;
    x0 = zeros(1, n);
    x0(5) = 1;
    
    % Simulazione
    T = 1:10;
    xc(1, :) = x0; % Assegnamento di riga
    for t = T
        X(t, :) = xc; % Assegnamento di riga
        xc = f(xc);
    end
    
    % Dopo poche iterazioni, il comportamento della distribuzione diventa
    % periodico (con periodo 2)
    for t = T
        plot_state(X(t,:));
    end
end

function plot_state(x)
    % Disegno uno stato
    figure();
    bar(x);
end


function xf = f(xc)
    n = length(xc);
    xf = zeros(1, n); % Prealloco (e' un po' piu' efficiente)
    for ii = 1:n
        % Di base, sommo le probabilita' di venire da celle adiancenti
        if ii > 1 % Se c'e' una posizione a sx
            if ii == 2 % Penultima posizione a sx
                xf(ii) = xf(ii) + 1.0 * xc(ii-1);
            else
                xf(ii) = xf(ii) + 0.5 * xc(ii-1);
            end
        end
        if ii < n % Se c'e' una posizione a dx
            if ii == n-1 % Penultima posizione a dx
                xf(ii) = xf(ii) + 1.0 * xc(ii+1);
            else
                xf(ii) = xf(ii) + 0.5 * xc(ii+1);
            end
        end  
    end
end