function random_walk2()
    % Configurazione
    x0 = [0, 0];
    
    % Simulazione
    T = 1:10000;
    xc(1, :) = x0; % Assegnamento di riga
    for t = T
        X(t, :) = xc; % Assegnamento di riga
        xc = f(xc);
    end
    

    % Disegno le coordinate (x,y) visitate
    figure();
    x = X(:, 1); % Prima colonna
    y = X(:, 2); % Seconda colonna
    p = plot(x, y);
end


function xf = f(xc)
    xf = xc; % Come base, copio lo stato corrente
    v = unifrnd(0, 1, 1);
    if v <= 0.25
        % Movimento a sx
        xf(1) = xf(1) - 1;
    else
        if v <= 0.5
            % Movimento a dx
            xf(1) = xf(1) + 1;
        else
            if v <= 0.75
                % Movimento in su
                xf(2) = xf(2) + 1;
            else
                % Movimento in gi?
                xf(2) = xf(2) - 1;
            end
        end
    end
end