function logistic_growth()
    % Configurazione
    x0 = 1000;
    r = 3.6; % Per r = 1.1 la popolazione cala, ma senza raggiungere lo 0
             % Per r = 1.2 la popolazione cresce e si assesta, senza
             % oscillazioni
             % Quando r > 2.0 cominciano ad esserci oscillazioni, ma lo
             % stato si stabilizza comunque
             % Per r = 3.1 il comportamento diventa periodico
             % Quando r supera 3.5, il comportamento diventa caotico
             
    k = 10000;
    
    % Simulazione
    T = 1:100;
    xc = x0;
    for t = T
        x(t) = xc;
        xc = f(xc, r, k);
    end
    
    % Disegno l'andamento nel tempo
    figure();
    plot(T, x);
end


function simulate(r)
end

function xf = f(xc, r, k)
    xf = r * xc * (1 - xc/k);
end